(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["localModsLoader"] = factory();
	else
		root["localModsLoader"] = factory();
})(self, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./module/loaders/localModsLoader.ts":
/*!*******************************************!*\
  !*** ./module/loaders/localModsLoader.ts ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var utils_1 = __webpack_require__(/*! ../utils */ "./module/utils.ts");
var modsDetector_1 = __importDefault(__webpack_require__(/*! ../modsDetector */ "./module/modsDetector.ts"));
var LocalModsLoader = /** @class */ (function () {
    function LocalModsLoader(loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = loggerFactory(this.name);
    }
    Object.defineProperty(LocalModsLoader.prototype, "name", {
        get: function () {
            return 'local-mods-loader';
        },
        enumerable: false,
        configurable: true
    });
    LocalModsLoader.prototype.getPaths = function () {
        var modsFolder = (0, utils_1.resolvePath)('mods');
        return Promise.resolve([modsFolder]);
    };
    LocalModsLoader.prototype.getOrder = function () {
        return 0;
    };
    LocalModsLoader.prototype.getModsDetector = function () {
        return new modsDetector_1.default(this.loggerFactory);
    };
    return LocalModsLoader;
}());
var ctor = LocalModsLoader;
exports["default"] = ctor;


/***/ }),

/***/ "./module/modsDetector.ts":
/*!********************************!*\
  !*** ./module/modsDetector.ts ***!
  \********************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var path_1 = __importDefault(__webpack_require__(/*! path */ "path"));
var utils_1 = __webpack_require__(/*! ./utils */ "./module/utils.ts");
var DefaultModsDetector = /** @class */ (function () {
    function DefaultModsDetector(loggerFactory) {
        this.modDeclarationUnitRegex = /({\s*"name"\s*:\s*"(.+)"\s*,\s*"status".+}\s*})\s*,?/;
        this.logger = loggerFactory('mod-detector');
    }
    Object.defineProperty(DefaultModsDetector.prototype, "noMods", {
        get: function () {
            return {
                mods: [],
                dependencies: []
            };
        },
        enumerable: false,
        configurable: true
    });
    DefaultModsDetector.prototype.detect = function (location) {
        return __awaiter(this, void 0, void 0, function () {
            var existsSync;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if ((0, utils_1.isBrowser)()) {
                            this.logger.error('Unable to detect mods when running game from browser.');
                            return [2 /*return*/, this.noMods];
                        }
                        if (typeof String.prototype.matchAll !== 'function') {
                            this.logger.error("Unable to detect mods: method 'String.prototype.matchAll' is not supported.");
                            return [2 /*return*/, this.noMods];
                        }
                        return [4 /*yield*/, (0, utils_1.getExistsSync)()];
                    case 1:
                        existsSync = _a.sent();
                        if (!existsSync(location)) {
                            return [2 /*return*/, this.noMods];
                        }
                        return [4 /*yield*/, this.getModsList(location)];
                    case 2: 
                    // TODO: Add manual mod loader.
                    return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    DefaultModsDetector.prototype.isModValidInfo = function (obj) {
        return Boolean(obj)
            && this.hasProperty(obj, 'name')
            && this.hasProperty(obj, 'status')
            && this.hasProperty(obj, 'parameters');
    };
    DefaultModsDetector.prototype.hasProperty = function (obj, property) {
        return property in obj;
    };
    DefaultModsDetector.prototype.parseModDeclaration = function (line) {
        var modDeclarationUnitMatch = line.match(this.modDeclarationUnitRegex);
        if (!modDeclarationUnitMatch) {
            return null;
        }
        var _a = __read(modDeclarationUnitMatch, 2), modDeclarationText = _a[1];
        var modInfo = null;
        try {
            // Dirty, but more tolerant to syntax errors way to parse json.
            var func = Function('return ' + modDeclarationText + ';');
            modInfo = func();
        }
        catch (e) {
            this.logger.warn({ error: e, declaration: modDeclarationText }, 'Unable to parse declaration.');
        }
        if (!this.isModValidInfo(modInfo)) {
            return null;
        }
        return modInfo;
    };
    DefaultModsDetector.prototype.parseModDeclarations = function (modContent) {
        var e_1, _a;
        var modDeclarationsTagsRegex = /\/\/\s*#MODS TXT LINES:([\s\S]+)\/\/\s*#MODS TXT LINES END/;
        var modDeclarationsMatch = modContent.match(modDeclarationsTagsRegex);
        if (!modDeclarationsMatch) {
            return [];
        }
        var declaredMods = [];
        var lines = modDeclarationsMatch[1].split('\n');
        try {
            for (var lines_1 = __values(lines), lines_1_1 = lines_1.next(); !lines_1_1.done; lines_1_1 = lines_1.next()) {
                var line = lines_1_1.value;
                var modInfo = this.parseModDeclaration(line);
                if (modInfo) {
                    declaredMods.push(modInfo);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (lines_1_1 && !lines_1_1.done && (_a = lines_1.return)) _a.call(lines_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return declaredMods;
    };
    ;
    DefaultModsDetector.prototype.getModsList = function (modsFolder) {
        return __awaiter(this, void 0, void 0, function () {
            var modsDependencies, modInfoMappings, readdirAsync, _a, _b, fileName, fullPath, e_2_1;
            var e_2, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        modsDependencies = [];
                        modInfoMappings = new Map();
                        return [4 /*yield*/, (0, utils_1.getReaddirAsync)()];
                    case 1:
                        readdirAsync = _d.sent();
                        _d.label = 2;
                    case 2:
                        _d.trys.push([2, 8, 9, 10]);
                        return [4 /*yield*/, readdirAsync(modsFolder)];
                    case 3:
                        _a = __values.apply(void 0, [_d.sent()]), _b = _a.next();
                        _d.label = 4;
                    case 4:
                        if (!!_b.done) return [3 /*break*/, 7];
                        fileName = _b.value;
                        fullPath = path_1.default.join(modsFolder, fileName);
                        return [4 /*yield*/, this.parseModsListFromFile(fullPath, modInfoMappings, modsDependencies)];
                    case 5:
                        _d.sent();
                        _d.label = 6;
                    case 6:
                        _b = _a.next();
                        return [3 /*break*/, 4];
                    case 7: return [3 /*break*/, 10];
                    case 8:
                        e_2_1 = _d.sent();
                        e_2 = { error: e_2_1 };
                        return [3 /*break*/, 10];
                    case 9:
                        try {
                            if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                        }
                        finally { if (e_2) throw e_2.error; }
                        return [7 /*endfinally*/];
                    case 10: return [2 /*return*/, {
                            mods: Array.from(modInfoMappings.values()),
                            dependencies: modsDependencies
                        }];
                }
            });
        });
    };
    DefaultModsDetector.prototype.parseModsListFromFile = function (fullPath, modInfoMappings, modsDependencies) {
        return __awaiter(this, void 0, void 0, function () {
            var modContent, error_1, declaredMods, previousModInfo, declaredMods_1, declaredMods_1_1, currentDeclaration, modName, emptyModInfo, storedModInfo, isOptional, modDeclaration;
            var e_3, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (path_1.default.extname(fullPath).toLowerCase() !== '.js') {
                            return [2 /*return*/];
                        }
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, (0, utils_1.queryFile)(fullPath)];
                    case 2:
                        modContent = _b.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        error_1 = _b.sent();
                        this.logger.error({ fullPath: fullPath, error: error_1 }, 'Unable to fetch mod');
                        return [2 /*return*/];
                    case 4:
                        declaredMods = this.parseModDeclarations(modContent);
                        try {
                            for (declaredMods_1 = __values(declaredMods), declaredMods_1_1 = declaredMods_1.next(); !declaredMods_1_1.done; declaredMods_1_1 = declaredMods_1.next()) {
                                currentDeclaration = declaredMods_1_1.value;
                                modName = currentDeclaration.name;
                                emptyModInfo = {
                                    parameters: {
                                        optional: true
                                    }
                                };
                                storedModInfo = modInfoMappings.get(modName) || emptyModInfo;
                                isOptional = Boolean(storedModInfo.parameters.optional &&
                                    currentDeclaration.parameters.optional);
                                modDeclaration = __assign(__assign(__assign({}, storedModInfo), currentDeclaration), { parameters: __assign(__assign(__assign({}, storedModInfo.parameters), currentDeclaration.parameters), { optional: isOptional }) });
                                modInfoMappings.set(modDeclaration.name, modDeclaration);
                                if (previousModInfo) {
                                    modsDependencies.push([previousModInfo.name, modDeclaration.name]);
                                }
                                previousModInfo = modDeclaration;
                            }
                        }
                        catch (e_3_1) { e_3 = { error: e_3_1 }; }
                        finally {
                            try {
                                if (declaredMods_1_1 && !declaredMods_1_1.done && (_a = declaredMods_1.return)) _a.call(declaredMods_1);
                            }
                            finally { if (e_3) throw e_3.error; }
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    return DefaultModsDetector;
}());
exports["default"] = DefaultModsDetector;


/***/ }),

/***/ "./module/utils.ts":
/*!*************************!*\
  !*** ./module/utils.ts ***!
  \*************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getFsAsync = exports.isBrowser = exports.getExistsSync = exports.getReaddirAsync = exports.ensureFsFunction = exports.queryFile = exports.getUniversalPath = exports.toUrl = exports.getRelativePath = exports.resolvePath = exports.getDetailedName = exports.isAndroid = exports.sleep = void 0;
var path_1 = __importDefault(__webpack_require__(/*! path */ "path"));
var util_1 = __webpack_require__(/*! util */ "util");
var process = __importStar(__webpack_require__(/*! process */ "process"));
function sleep(ms) {
    return new Promise(function (resolve) { return setTimeout(resolve, ms); });
}
exports.sleep = sleep;
var emulatorsList = new Set(['joiplay', 'maldives']);
function isAndroid() {
    return !!process.env.USER && emulatorsList.has(process.env.USER);
}
exports.isAndroid = isAndroid;
function getDetailedName(mod) {
    return mod.parameters.displayedName
        ? "'".concat(mod.parameters.displayedName, "' (").concat(mod.name, ")")
        : "'".concat(mod.name, "'");
}
exports.getDetailedName = getDetailedName;
function resolvePath() {
    var _a;
    var localPath = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        localPath[_i] = arguments[_i];
    }
    var rootFolder = path_1.default.dirname(((_a = process.mainModule) === null || _a === void 0 ? void 0 : _a.filename) || '');
    return path_1.default.resolve.apply(path_1.default, __spreadArray([rootFolder], __read(localPath), false));
}
exports.resolvePath = resolvePath;
function getRelativePath(absolutePath) {
    var _a;
    return path_1.default.relative(path_1.default.dirname(((_a = process.mainModule) === null || _a === void 0 ? void 0 : _a.filename) || ''), resolvePath(absolutePath));
}
exports.getRelativePath = getRelativePath;
function toUrl(filePath) {
    return getUniversalPath(getRelativePath(filePath));
}
exports.toUrl = toUrl;
function getUniversalPath(location) {
    return path_1.default.sep === path_1.default.posix.sep
        ? location
        : location.split(path_1.default.sep).join(path_1.default.posix.sep);
}
exports.getUniversalPath = getUniversalPath;
function queryFile(filePath) {
    return __awaiter(this, void 0, void 0, function () {
        var response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, fetch(toUrl(filePath))];
                case 1:
                    response = _a.sent();
                    return [4 /*yield*/, response.text()];
                case 2: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.queryFile = queryFile;
function ensureFsFunction(name) {
    var func = __webpack_require__(/*! fs */ "fs")[name];
    if (typeof func !== 'function') {
        throw new Error("Function '".concat(name, "' is not supported in fs API."));
    }
    return func;
}
exports.ensureFsFunction = ensureFsFunction;
function getReaddirAsync() {
    var _a, _b, _c;
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0: return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(__webpack_require__(/*! fs */ "fs")); })];
                case 1: return [2 /*return*/, (_c = (_b = (_a = (_d.sent())) === null || _a === void 0 ? void 0 : _a.promises) === null || _b === void 0 ? void 0 : _b.readdir) !== null && _c !== void 0 ? _c : (0, util_1.promisify)(ensureFsFunction('readdir'))];
            }
        });
    });
}
exports.getReaddirAsync = getReaddirAsync;
function getExistsSync() {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(__webpack_require__(/*! fs */ "fs")); })];
                case 1: return [2 /*return*/, (_a.sent()).existsSync];
            }
        });
    });
}
exports.getExistsSync = getExistsSync;
function isBrowser() {
    return (typeof globalThis.require !== 'function') || (typeof process !== 'object');
}
exports.isBrowser = isBrowser;
function getFsAsync(getAsyncFs, getCallbackFs, getSyncFs) {
    var asyncFs = getAsyncFs();
    if (asyncFs) {
        return asyncFs;
    }
    console.warn("Promise version of function '".concat(getAsyncFs, "' is not supported in current fs API. ") +
        'Falling back to callback implementation.');
    var callbackFs = getCallbackFs();
    if (callbackFs) {
        return (0, util_1.promisify)(getCallbackFs);
    }
    console.warn("Callback version of function '".concat(getCallbackFs, "' is not supported in current fs API. ") +
        'Falling back to sync implementation.');
    var syncFunction = getSyncFs();
    if (!syncFunction) {
        throw new Error("Function '".concat(getSyncFs, "' is not supported in fs API."));
    }
    return (function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return new Promise(function (resolve, reject) {
            try {
                var result = syncFunction.apply({}, args);
                resolve(result);
            }
            catch (error) {
                reject(error);
            }
        });
    });
}
exports.getFsAsync = getFsAsync;


/***/ }),

/***/ "fs":
/*!*********************!*\
  !*** external "fs" ***!
  \*********************/
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ "path":
/*!***********************!*\
  !*** external "path" ***!
  \***********************/
/***/ ((module) => {

module.exports = require("path");

/***/ }),

/***/ "process":
/*!**************************!*\
  !*** external "process" ***!
  \**************************/
/***/ ((module) => {

module.exports = require("process");

/***/ }),

/***/ "util":
/*!***********************!*\
  !*** external "util" ***!
  \***********************/
/***/ ((module) => {

module.exports = require("util");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./module/loaders/localModsLoader.ts");
/******/ 	
/******/ 	return __webpack_exports__;
/******/ })()
;
});
//# sourceMappingURL=localModsLoader.js.map